declare global {
    interface Array<T> {
        removeObjectDuplicates: (getProperty: (item: T) => any) => Array<T>;
    }


    interface String {
        toBoolean: () => boolean;
        capitalizingFirstLetter: () => string;
        capitalizeName: () => string;
        convertWithEnvVars: () => string;
    }
}

function registerAll() {
    registerBigIntJson();
    registerArrayRemoveObjectDuplicates();
    registerStringToBoolean();
    registerStringCapitalizingFirstLetter();
    registerStringCapitalizeName();
    registerStringConvertWithEnvVars();
}

function registerBigIntJson() {
    (BigInt.prototype as any).toJSON = function () {
        return this.toString();
    };
}

function registerArrayRemoveObjectDuplicates() {
    Array.prototype.removeObjectDuplicates = function <T>(this: Array<T>, getProperty: (item: T) => any): Array<T> {
        return this.reduce((accumulator: Array<T>, current: T) => {
            if ( !accumulator.find((item: any) => getProperty(item) === getProperty(current)) ) {
                accumulator.push(current);
            }
            return accumulator;
        }, Array<T>());
    };
}

function registerStringToBoolean() {
    String.prototype.toBoolean = function (this: string): boolean {
        const tmp = this.toLowerCase().trim();
        return tmp === 'true' || tmp === '1';
    };
}

function registerStringCapitalizingFirstLetter() {
    String.prototype.capitalizingFirstLetter = function (this: string): string {
        return this.charAt(0).toUpperCase() + this.slice(1);
    };
}

function registerStringCapitalizeName() {
    String.prototype.capitalizeName = function (this: string): string {
        return this.trim().replace(/(?:^|\s|-)\S/g, s => s.toUpperCase());
    };
}

function registerStringConvertWithEnvVars() {
    String.prototype.convertWithEnvVars = function (this: string): string {
        return this.replace(/\${?([a-zA-Z0-9_]+)}?/g, (_match: string, p1: string) => {
            return process.env[p1] || '';
        });
    };
}

registerAll();


export default null;