Source: recursive-readdir-files
===
Modified for Dojo
===

## Usage

```js
import recursiveReaddirFiles from 'recursive-readdir-files';


const files = await recursiveReaddirFiles(process.cwd(), {
    ignored: /\/(node_modules|\.git)/
});

// `files` is an array
console.log(files);
// ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
// [
//   {
//     dev: 16777233,
//     mode: 33188,
//     nlink: 1,
//     uid: 501,
//     gid: 20,
//     rdev: 0,
//     blksize: 4096,
//     ino: 145023089,
//     size: 89,
//     blocks: 8,
//     atimeMs: 1649303678077.934,
//     mtimeMs: 1649303676847.1777,
//     ctimeMs: 1649303676847.1777,
//     birthtimeMs: 1649301118132.6782,
//     atime: 2022-04-07T03:54:38.078Z,
//     mtime: 2022-04-07T03:54:36.847Z,
//     ctime: 2022-04-07T03:54:36.847Z,
//     birthtime: 2022-04-07T03:11:58.133Z,
//     name: 'watch.ts',
//     path: '/Users/xxx/watch.ts',
//     ext: 'ts'
//   },
//   // ...
// ]
```

Or

```js
recursiveReaddirFiles(process.cwd(), {
    ignored: /\/(node_modules|\.git)/
}, (filepath, state) => {
    console.log(filepath);
    // 👉 /Users/xxx/watch.ts
    console.log(state.isFile());      // 👉 true
    console.log(state.isDirectory()); // 👉 false
    console.log(state);
    // ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
    // {
    //   dev: 16777233,
    //   mode: 33188,
    //   nlink: 1,
    //   uid: 501,
    //   gid: 20,
    //   rdev: 0,
    //   blksize: 4096,
    //   ino: 145023089,
    //   size: 89,
    //   blocks: 8,
    //   atimeMs: 1649303678077.934,
    //   mtimeMs: 1649303676847.1777,
    //   ctimeMs: 1649303676847.1777,
    //   birthtimeMs: 1649301118132.6782,
    //   atime: 2022-04-07T03:54:38.078Z,
    //   mtime: 2022-04-07T03:54:36.847Z,
    //   ctime: 2022-04-07T03:54:36.847Z,
    //   birthtime: 2022-04-07T03:11:58.133Z,
    //   name: 'watch.ts',
    //   path: '/Users/xxx/watch.ts',
    //   ext: 'ts'
    // }
})
```

## Options

```ts
export interface RecursiveReaddirFilesOptions {
    /**
     * Ignore files
     * @example `/\/(node_modules|\.git)/`
     */
    ignored?: RegExp;
    /**
     * Specifies a list of `glob` patterns that match files to be included in compilation.
     * @example `/(\.json)$/`
     */
    include?: RegExp;
    /**
     * Specifies a list of files to be excluded from compilation.
     * @example `/(package\.json)$/`
     */
    exclude?: RegExp;
    /** Provide filtering methods to filter data. */
    filter?: (item: IFileDirStat) => boolean;
    /** Do not give the absolute path but the relative one from the root folder */
    replacePathByRelativeOne?: boolean;
    /** Remove stats that are not necessary for transfert */
    liteStats?: boolean;
}
```

## Result

```ts
import fs from 'node:fs';


export interface IFileDirStat extends Partial<fs.Stats> {
    /**
     * @example `/a/sum.jpg` => `sum.jpg`
     */
    name: string;
    /**
     * @example `/basic/src/utils/sum.ts`
     */
    path: string;
    /**
     * @example `/a/b.jpg` => `jpg`
     */
    ext?: string;
}


declare type Callback = (filepath: string, stat: IFileDirStat) => void;
export default function recursiveReaddirFiles(rootPath: string, options?: RecursiveReaddirFilesOptions, callback?: Callback): Promise<IFileDirStat[]>;
export { recursiveReaddirFiles };
export declare const getStat: (filepath: string) => Promise<IFileDirStat>;
/**
 * Get ext
 * @param {String} filePath `/a/b.jpg` => `jpg`
 */
export declare const getExt: (filePath: string) => string;
```

## License

Licensed under the MIT License.
