import axios          from 'axios';
import GitlabPipeline from '../types/Gitlab/GitlabPipeline';
import GitlabRoute    from '../types/Gitlab/GitlabRoute';
import SharedConfig   from '../config/SharedConfig';


class GitlabManager {
    private getApiUrl(route: GitlabRoute): string {
        return `${ SharedConfig.gitlab.apiURL }${ route }`;
    }

    async getRepositoryPipelines(repoId: number, branch: string = 'main'): Promise<Array<GitlabPipeline>> {
        const response = await axios.get<Array<GitlabPipeline>>(this.getApiUrl(GitlabRoute.REPOSITORY_PIPELINES).replace('{{id}}', String(repoId)), {
            params: {
                ref: branch
            }
        });

        return response.data;
    }
}


export default new GitlabManager();
