import GitlabPipelineStatus from './GitlabPipelineStatus';
import GitlabPipelineSource from './GitlabPipelineSource';
import GitlabUser           from './GitlabUser';


interface GitlabPipeline {
    id: number,
    iid: number,
    project_id: number,
    status: GitlabPipelineStatus,
    source: GitlabPipelineSource,
    ref: string,
    sha: string,
    before_sha: string,
    tag: boolean,
    name: string,
    yaml_errors: string | null,
    user: GitlabUser,
    web_url: string,
    created_at: string,
    updated_at: string,
    started_at: string | null,
    finished_at: string | null,
    committed_at: string | null,
    duration: number | null,
    queued_duration: number | null,
    coverage: string | null,
}


export default GitlabPipeline;