import AssignmentFile       from '../../types/Dojo/AssignmentFile.js';
import DojoStatusCode       from '../../types/Dojo/DojoStatusCode.js';
import Json5FileValidator   from '../Json5FileValidator.js';
import * as Gitlab          from '@gitbeaker/rest';
import GitlabPipelineStatus from '../../types/Gitlab/GitlabPipelineStatus.js';
import GitlabManager        from '../../../managers/GitlabManager.js';


class SharedAssignmentHelper {
    validateDescriptionFile(filePathOrStr: string, isFile: boolean = true, version: number = 1): { content: AssignmentFile | undefined, isValid: boolean, error: string | null } {
        if ( version === 1 ) {
            return Json5FileValidator.validateFile(AssignmentFile, filePathOrStr, isFile);
        } else {
            return {
                content: undefined,
                isValid: false,
                error  : `Version ${ version } not supported`
            };
        }
    }

    async isPublishable(repositoryId: number): Promise<{ isPublishable: boolean, lastPipeline: Gitlab.PipelineSchema | null, status?: { code: DojoStatusCode, message: string } }> {
        const pipelines = await GitlabManager.getRepositoryPipelines(repositoryId, 'main');
        if ( pipelines.length > 0 ) {
            const lastPipeline = pipelines[0];
            if ( lastPipeline.status !== GitlabPipelineStatus.SUCCESS.valueOf() ) {
                return {
                    isPublishable: false,
                    lastPipeline : lastPipeline,
                    status       : {
                        code   : DojoStatusCode.ASSIGNMENT_PUBLISH_PIPELINE_FAILED,
                        message: `Last pipeline status is not "${ GitlabPipelineStatus.SUCCESS }" but "${ lastPipeline.status }".`
                    }
                };
            } else {
                return {
                    isPublishable: true,
                    lastPipeline : lastPipeline
                };
            }
        } else {
            return {
                isPublishable: false,
                lastPipeline : null,
                status       : {
                    code   : DojoStatusCode.ASSIGNMENT_PUBLISH_NO_PIPELINE,
                    message: 'No pipeline found for this assignment.'
                }
            };
        }
    }
}


export default new SharedAssignmentHelper();