import fs   from 'fs/promises';
import path from 'path';


class Toolbox {
    public urlToPath(url: string): string {
        return url.replace(/^([a-z]{3,5}:\/{2})?[a-z.@]+(:[0-9]{1,5})?.(.*)/, '$3').replace('.git', '');
    }

    /*
     Source of getAllFiles and getTotalSize (modified for this project): https://coderrocketfuel.com/article/get-the-total-size-of-all-files-in-a-directory-using-node-js
     */
    private async getAllFiles(dirPath: string, arrayOfFiles: Array<string> = []): Promise<Array<string>> {
        const files = await fs.readdir(dirPath);

        await Promise.all(files.map(async file => {
            const filePath = path.join(dirPath, file);
            if ( (await fs.stat(filePath)).isDirectory() ) {
                arrayOfFiles = await this.getAllFiles(filePath, arrayOfFiles);
            } else {
                arrayOfFiles.push(path.join(dirPath, file));
            }
        }));

        return arrayOfFiles;
    }

    private async getTotalSize(directoryPath: string): Promise<number> {
        const arrayOfFiles = await this.getAllFiles(directoryPath);

        let totalSize = 0;

        for ( const filePath of arrayOfFiles ) {
            totalSize += (await fs.stat(filePath)).size;
        }

        return totalSize;
    }

    get fs() {
        return {
            getAllFiles : this.getAllFiles.bind(this),
            getTotalSize: this.getTotalSize.bind(this)
        };
    }

    public snakeToCamel(str: string): string {
        return str.toLowerCase().replace(/([-_][a-z])/g, (group: string) => group.toUpperCase().replace('-', '').replace('_', ''));
    }

    public getKeysWithPrefix(obj: object, prefix: string): Array<string> {
        return Object.keys(obj).filter(key => key.startsWith(prefix));
    }

    public isString(value: unknown): value is string {
        return typeof value === 'string' || value instanceof String;
    }
}


export default new Toolbox();
