import CommanderCommand   from '../../CommanderCommand.js';
import DojoBackendManager from '../../../managers/DojoBackendManager';
import { Option }         from 'commander';
import Config             from '../../../config/Config';


class SettingsApiCommand extends CommanderCommand {
    protected commandName: string = 'api';

    protected defineCommand() {
        this.command
            .description('change Dojo API URL')
            .option('-u, --url <string>', 'specify the url of the Dojo API')
            .addOption(new Option('--clean', 'clean the Dojo API settings').conflicts('url'))
            .action(this.commandAction.bind(this));
    }

    protected async commandAction(options: { url: string, clean: boolean }): Promise<void> {
        if ( options.clean ) {
            await DojoBackendManager.cleanApiUrl();
        } else if ( options.url ) {
            await DojoBackendManager.setApiUrl(options.url);
        } else if ( Config.interactiveMode ) {
            await DojoBackendManager.askApiUrl(true);
        } else {
            this.command.help();
        }
    }
}


export default new SettingsApiCommand();