import CommanderCommand from '../../CommanderCommand.js';
import { Option }       from 'commander';
import Config           from '../../../config/Config';


class SettingsInteractiveModeCommand extends CommanderCommand {
    protected commandName: string = 'interactive-mode';

    protected defineCommand() {
        this.command
            .description('enable / disable interactive mode by default')
            .addOption(new Option('-i, --interactive', 'ENABLE interactive mode by default'))
            .addOption(new Option('-n, --no_interactive', 'DISABLE interactive mode by default').conflicts('interactive')) // WARNING: Due to a bug in commander.js, the conflicts method doesn't work as expected if the command is named no-interactive
            .action(this.commandAction.bind(this));
    }

    protected async commandAction(options: { interactive: boolean, no_interactive: boolean }): Promise<void> {
        if ( options.interactive ) {
            Config.setInteractiveMode(true);
        } else if ( options.no_interactive ) {
            Config.setInteractiveMode(false);
        } else if ( Config.interactiveMode ) {
            await Config.askInteractiveMode();
        } else {
            this.command.help();
        }
    }
}


export default new SettingsInteractiveModeCommand();