import CommanderCommand  from '../../CommanderCommand';
import Config            from '../../../config/Config';
import { Option }        from 'commander';
import ExerciseRunHelper from '../../../helpers/Dojo/ExerciseRunHelper';


class AssignmentRunCommand extends CommanderCommand {
    protected commandName: string = 'run';

    protected defineCommand() {
        // This command is synced with the "exercise run" command
        this.command
        .description('locally run the assignment as an exercise')
        .option('-p, --path <value>', 'exercise path', Config.folders.defaultLocalExercise)
        .option('-v, --verbose', 'verbose mode - display principal container output in live')
        .addOption(new Option('-w, --super-verbose', 'verbose mode - display all docker compose logs (build included) in live').conflicts('verbose'))
        .addOption(new Option('--verbose-ssj2').hideHelp().implies({ superVerbose: true }))
        .action(this.commandAction.bind(this));
    }

    protected async commandAction(options: { path: string, verbose: boolean, superVerbose: boolean }): Promise<void> {
        await ExerciseRunHelper.run(options);
    }
}


export default new AssignmentRunCommand();