import CommanderCommand            from '../CommanderCommand.js';
import AssignmentCreateCommand     from './subcommands/AssignmentCreateCommand.js';
import AssignmentPublishCommand    from './subcommands/AssignmentPublishCommand.js';
import AssignmentUnpublishCommand  from './subcommands/AssignmentUnpublishCommand.js';
import AssignmentCheckCommand      from './subcommands/AssignmentCheckCommand.js';
import AssignmentRunCommand        from './subcommands/AssignmentRunCommand.js';
import AssignmentCorrectionCommand from './subcommands/correction/AssignmentCorrectionCommand.js';


class AssignmentCommand extends CommanderCommand {
    protected commandName: string = 'assignment';

    protected defineCommand() {
        this.command
            .description('manage an assignment');
    }

    protected defineSubCommands() {
        AssignmentCreateCommand.registerOnCommand(this.command);
        AssignmentCheckCommand.registerOnCommand(this.command);
        AssignmentRunCommand.registerOnCommand(this.command);
        AssignmentPublishCommand.registerOnCommand(this.command);
        AssignmentUnpublishCommand.registerOnCommand(this.command);
        AssignmentCorrectionCommand.registerOnCommand(this.command);
    }

    protected async commandAction(): Promise<void> {
        // No action
    }
}


export default new AssignmentCommand();