import CommanderCommand  from '../../CommanderCommand.js';
import ExerciseRunHelper from '../../../helpers/Dojo/ExerciseRunHelper.js';
import GlobalHelper      from '../../../helpers/GlobalHelper.js';


class AssignmentRunCommand extends CommanderCommand {
    protected commandName: string = 'run';

    protected defineCommand() {
        GlobalHelper.runCommandDefinition(this.command)
            .description('locally run the assignment as an exercise')
            .action(this.commandAction.bind(this));
    }

    protected async commandAction(options: { path: string, verbose: boolean, superVerbose: boolean }): Promise<void> {
        await (new ExerciseRunHelper(options)).run();
    }
}


export default new AssignmentRunCommand();