import CommanderCommand                  from '../../../CommanderCommand.js';
import AssignmentCorrectionLinkCommand   from './subcommands/AssignmentCorrectionLinkCommand.js';
import AssignmentCorrectionUpdateCommand from './subcommands/AssignmentCorrectionUpdateCommand.js';
import AssignmentCorrectionUnlinkCommand from './subcommands/AssignmentCorrectionUnlinkCommand.js';


class AssignmentCorrectionCommand extends CommanderCommand {
    protected commandName: string = 'correction';

    protected defineCommand() {
        this.command
            .description('manage corrections of an assignment');
    }

    protected defineSubCommands() {
        AssignmentCorrectionLinkCommand.registerOnCommand(this.command);
        AssignmentCorrectionUpdateCommand.registerOnCommand(this.command);
        AssignmentCorrectionUnlinkCommand.registerOnCommand(this.command);
    }

    protected async commandAction(): Promise<void> {
        // No action
    }
}


export default new AssignmentCorrectionCommand();