import Assignment         from '../../../../../sharedByClients/models/Assignment.js';
import TextStyle          from '../../../../../types/TextStyle.js';
import DojoBackendManager from '../../../../../managers/DojoBackendManager.js';
import CommanderCommand   from '../../../../CommanderCommand.js';
import GlobalHelper       from '../../../../../helpers/GlobalHelper.js';


class AssignmentCorrectionLinkCommand extends CommanderCommand {
    protected commandName: string = 'unlink';

    protected defineCommand() {
        this.command
            .description('remove a correction of an assignment')
            .argument('<string>', 'id or url of the exercise that is the correction')
            .requiredOption('-a, --assignment <string>', 'id or url of the assignment of the correction')
            .action(this.commandAction.bind(this));
    }

    protected async commandAction(exerciseIdOrUrl: string, options: { assignment: string }): Promise<void> {
        let assignment!: Assignment | undefined;

        // Check access
        {
            assignment = await GlobalHelper.checkAssignmentCorrectionAccess(options.assignment);
            if ( !assignment ) {
                return;
            }
        }

        // Link the exercise
        {
            console.log(TextStyle.BLOCK('Please wait while we unlink the exercise...'));

            await DojoBackendManager.unlinkCorrection(exerciseIdOrUrl, assignment);
        }
    }
}


export default new AssignmentCorrectionLinkCommand();