import CommanderCommand                  from '../../../CommanderCommand';
import AssignmentCorrectionLinkCommand   from './subcommands/AssignmentCorrectionLinkCommand';
import AssignmentCorrectionUpdateCommand from './subcommands/AssignmentCorrectionUpdateCommand';


class AssignmentCorrectionCommand extends CommanderCommand {
    protected commandName: string = 'correction';

    protected defineCommand() {
        this.command
            .description('manage corrections of an assignment');
    }

    protected defineSubCommands() {
        AssignmentCorrectionLinkCommand.registerOnCommand(this.command);
        AssignmentCorrectionUpdateCommand.registerOnCommand(this.command);
    }

    protected async commandAction(): Promise<void> {
        // No action
    }
}


export default new AssignmentCorrectionCommand();