#ifndef _HM_H_
#define _HM_H_

#include <stdbool.h>

#define MAX_LEN 80

typedef enum { empty, occupied, deleted } state_t;

typedef struct _cell_t {
    state_t state;
    char key[MAX_LEN];
    char value[MAX_LEN];
} cell_t;

typedef struct _hm {
    int capacity;
    cell_t *table;
} hm;

void hm_init(hm *h, int capacity);
void hm_destroy(hm *h);
bool hm_set(hm *h, char *key, char *value);
char *hm_get(hm h, char *key);
char *hm_remove(hm *h, char *key);
void hm_print(hm h);

#endif
