//Convertir date_naissance en Date dans Etudiants
print("Conversion des dates dans Etudiants...");
db.Etudiants.updateMany(
  { date_naissance: { $type: "string" } },
  [
    { $set: { date_naissance: { $toDate: "$date_naissance" } } }
  ]
);

//////////
//////////
//////////
//////////
//////////

// 1. Requête d'insertion
print("=== 1. Insertion d'un nouvel étudiant ===");
db.Etudiants.insertOne({
    id_etudiant: 8,
    nom: "Dubois",
    prenom: "Alice",
    date_naissance: new Date("2002-07-19"), // Convertir en Date
    id_dept: 3
});
printjson(db.Etudiants.findOne({id_etudiant: 8}));

// 2. Requête de modification
print("\n=== 2. Modification d'un enseignant ===");
print("Avant modification:");
printjson(db.Enseignants.findOne({nom: "Martin", prenom: "Sophie"}));
db.Enseignants.updateOne(
    { nom: "Martin", prenom: "Sophie" },
    { $set: { id_dept: 3 } }
);
print("Après modification:");
printjson(db.Enseignants.findOne({nom: "Martin", prenom: "Sophie"}));

// 3. Requête de suppression
print("\n=== 3. Suppression de salles ===");
print("Nombre de salles avec capacité < 30 avant suppression:");
print(db.Salles.countDocuments({capacite: {$lt: 30}}));
db.Salles.deleteMany({ capacite: { $lt: 30 } });
print("Nombre de salles avec capacité < 30 après suppression:");
print(db.Salles.countDocuments({capacite: {$lt: 30}}));

// 4.1 Recherche d'étudiants nés après 2000 - CORRIGÉ
print("\n=== 4.1 Recherche d'étudiants nés après 2000 ===");
db.Etudiants.find(
    { date_naissance: { $gt: new Date("2000-12-31") } }, // Utiliser Date au lieu de string
    { _id: 0, nom: 1, prenom: 1, date_naissance: 1 }
).forEach(printjson); // Utiliser forEach au lieu de pretty()

// 4.2 Recherche de cours avec plus de 4 crédits - CORRIGÉ
print("\n=== 4.2 Recherche de cours avec plus de 4 crédits ===");
db.Cours.find(
    { credit: { $gt: 4 } },
    { _id: 0, nom_cours: 1, credit: 1 }
).forEach(printjson); // Utiliser forEach au lieu de pretty()

// 5. Requête d'aggregation (moyenne des notes par cours) - CORRIGÉ
print("\n=== 5. Aggregation: moyenne des notes par cours ===");
db.Inscriptions.aggregate([
    {
        $lookup: {
            from: "Cours",
            localField: "id_cours",
            foreignField: "id_cours",
            as: "cours"
        }
    },
    { $unwind: "$cours" },
    {
        $group: {
            _id: "$cours.nom_cours",
            moyenne: { $avg: "$note" }
        }
    },
    {
        $project: {
            _id: 0,
            cours: "$_id",
            moyenne: { $round: ["$moyenne", 2] }
        }
    }
]).forEach(printjson); // Utiliser forEach au lieu de pretty()

// 6. Requête MapReduce (total de crédits par étudiant) - CORRIGÉ
print("\n=== 6. MapReduce: total de crédits par étudiant ===");

// Créer d'abord une collection temporaire avec les données nécessaires
db.Inscriptions.aggregate([
    {
        $lookup: {
            from: "Cours",
            localField: "id_cours",
            foreignField: "id_cours",
            as: "cours"
        }
    },
    { $unwind: "$cours" },
    {
        $project: {
            id_etudiant: 1,
            credit: "$cours.credit"
        }
    },
    { $out: "temp_inscriptions_credits" }
]);

// Maintenant utiliser MapReduce sur cette collection temporaire
var mapFunction = function() {
    emit(this.id_etudiant, this.credit);
};

var reduceFunction = function(key, values) {
    return Array.sum(values);
};

db.temp_inscriptions_credits.mapReduce(
    mapFunction,
    reduceFunction,
    {
        out: "credits_etudiants"
    }
);

// Afficher les résultats avec les noms des étudiants
print("Total de crédits par étudiant (MapReduce):");
db.credits_etudiants.aggregate([
    {
        $lookup: {
            from: "Etudiants",
            localField: "_id",
            foreignField: "id_etudiant",
            as: "etudiant"
        }
    },
    { $unwind: "$etudiant" },
    {
        $project: {
            _id: 0,
            nom: "$etudiant.nom",
            prenom: "$etudiant.prenom",
            total_credits: "$value"
        }
    },
    { $sort: { total_credits: -1 } }
]).forEach(printjson);

// Nettoyer la collection temporaire
db.temp_inscriptions_credits.drop();