# sqlite-to-mongodb.py
import sqlite3
import json
import datetime

def date_handler(obj):
    if isinstance(obj, datetime.date):
        return obj.isoformat()
    elif isinstance(obj, datetime.time):
        return obj.isoformat()
    elif isinstance(obj, datetime.datetime):
        return obj.isoformat()
    else:
        return str(obj)

# Connexion à la base SQLite
conn = sqlite3.connect('ecole.db')
conn.row_factory = sqlite3.Row

# Activer la détection des types DATE/TIME
conn.execute("PRAGMA foreign_keys = ON;")

# Collections à exporter
tables = ['Departement', 'Enseignant', 'Cours', 'Etudiant', 'Inscription', 'Salle', 'Seance']

for table in tables:
    cursor = conn.execute(f'SELECT * FROM {table}')
    rows = [dict(row) for row in cursor.fetchall()]
    
    # Conversion des types spécifiques
    for row in rows:
        for key, value in row.items():
            if isinstance(value, (datetime.date, datetime.time, datetime.datetime)):
                row[key] = value.isoformat()
    
    # Écriture dans un fichier JSON
    with open(f'{table.lower()}.json', 'w', encoding='utf-8') as f:
        json.dump(rows, f, indent=2, default=date_handler, ensure_ascii=False)

conn.close()