from mpl_toolkits.mplot3d import Axes3D
from matplotlib import cm
from matplotlib import pyplot as plt
from load_vec import load_vector
import numpy as np


TYPE_OF_DATA = 'curve'


def show_1d():
    X = load_vector("../X_1D.vec")
    Y = load_vector("../Y_1D.vec")

    if TYPE_OF_DATA == 'curve':
        plt.plot(X, Y, c='g', label="my curve")
    else:
        plt.scatter(X, Y, c='r', marker='x', label="my points")

    plt.title("My data")
    plt.xlabel("X")
    plt.ylabel("Y")
    plt.legend(loc="upper right")

    plt.show()


def show_2d():
    fig = plt.figure()
    ax = fig.gca(projection='3d')

    X = load_vector("../X_2D.vec")
    Y = load_vector("../Y_2D.vec")
    Z = load_vector("../Z_2D.vec")

    if TYPE_OF_DATA == 'curve':
        ax.plot(X, Y, Z, c='r', label="my curve")
    else:
        ax.scatter(X, Y, Z, c='r', marker='x', label="my points")

    ax.set_title("My data")
    ax.set_xlabel("X")
    ax.set_ylabel("Y")
    ax.set_zlabel("Z")
    ax.legend(loc="upper right")

    plt.show()


show_1d()
show_2d()
