import numpy as np
from fft import compute_rfft
import matplotlib.pyplot as plt
from frequency_domain_s_processing import generate_frequency_vector_f_fs, generate_f_and_n_for_lists_of_N, generate_sinusoidal_signal_freq_domain
from time_domain_s_processing import generate_time_vector_t_fs_n, generate_t_and_n_for_lists_of_T, generate_sinusiodal_signal,generate_sine_wave
from scipy.fft import rfft, rfftfreq
# VIZUALISATION

def analyze_signal(S, Fs):
    """
    Analyze both time-domain and frequency-domain characteristics of a signal.

    Parameters:
        S (array_like): Signal data as a NumPy array.
        Fs (int): Sampling frequency (Hz).
    
    Returns:
        tuple: Tuple containing frequency array, amplitude spectrum, length of the signal, and other information.
    """
    # Convert the signal data into a NumPy array
    S = np.array(S)

    # Perform the Real Fast Fourier Transform (RFFT)
    print("Performing RFFT...")
    rfft_result,A ,phi = compute_rfft(S)

    # Extract frequencies from the amplitude spectrum
    print("Extracting Frequencies...")
    N = len(S)
    T = N / Fs
   
    fs_time = 1 / T  # Sampling interval 
    fr, n = generate_f_and_n_for_lists_of_N(Fs,N)
    fs_freq = 1/Fs  # Sampling interval
    t, n = generate_t_and_n_for_lists_of_T(Fs,T,start_time=0)



    # Analyze time-domain characteristics
    print("\nTime Domain Analysis:")
    print("Signal Duration (s):", T)
    print("lenght of the signal:", N)
    print("Sampling interval (s):", fs_time)
    print("Average time vector:", np.mean(t), "seconds")
    print("Number of Salmples:", n)


    # Analyze frequency-domain characteristics
    print("\nFrequency Domain Analysis:")
    print("frequencies:", min(fr), "Hz")
    print("Sampling interval (s):", fs_freq)
    print( "Sampling frequency (Fs):", Fs)
    print("RFFT Result:", rfft_result)
    print( "Amplitude Spectrum:", A)
    print( "Phase Spectrum:", phi)


    return fr, fs_time, rfft_result, Fs, A, fs_freq ,phi, T, t, 

def plot_amplitude_spectrum(rfft_result):
    plt.figure(figsize=(10, 6))
    plt.subplot(2, 2, 1)
    plt.plot(range(len(rfft_result)), np.abs(rfft_result), ".r")
    plt.title("Amplitude des coefficients")
    plt.tight_layout()
    plt.show()

def Plot_des_signaux_temporels(t,T,S):
    plt.figure(figsize=(14, 6))
    plt.subplot(2, 2, 1)
    plt.plot(t, S)
    plt.title("Signal - Durée: {} secondes".format(T))
    plt.xlabel("Temps (s)")
    plt.ylabel("Amplitude")
    plt.tight_layout()
    plt.show()


    """
    N = len(S)
    yf = rfft(S)
    xf = rfftfreq(N, 1 / Fs)
    plt.figure()
    plt.plot(xf, np.abs(yf))
    plt.title(title)
    plt.xlabel('Frequency (Hz)')
    plt.ylabel('Amplitude')
    plt.grid()
    plt.show()

def plot_phase_spectrum(S, Fs, title):
    N = len(S)
    yf = rfft(S)
    xf = rfftfreq(N, 1 / Fs)
    plt.figure()
    plt.plot(xf, np.angle(yf))
    plt.title(title)
    plt.xlabel('Frequency (Hz)')
    plt.ylabel('Phase (radians)')
    plt.grid()
    plt.show()

def analyze_frequencies(S, Fs):
    N = len(S)
    yf = rfft(S)
    amplitude_spectrum = np.abs(yf)
    xf = rfftfreq(N, 1 / Fs)
    phase_spectrum = np.angle(yf)

    
# Compute summary statistics
    max_amplitude = np.max(amplitude_spectrum)
    min_amplitude = np.min(amplitude_spectrum)
    mean_amplitude = np.mean(amplitude_spectrum)
    
    max_phase = np.max(phase_spectrum)
    min_phase = np.min(phase_spectrum)
    mean_phase = np.mean(phase_spectrum)
    
    return xf, max_amplitude, min_amplitude, mean_amplitude, max_phase, min_phase, mean_phase

def print_frequency_comparison(original_freqs, max_orig_amp, min_orig_amp, mean_orig_amp, max_orig_phase, min_orig_phase, mean_orig_phase,
                               filtered_freqs, max_filtered_amp, min_filtered_amp, mean_filtered_amp, max_filtered_phase, min_filtered_phase, mean_filtered_phase,
                               recovered_freqs, max_recovered_amp, min_recovered_amp, mean_recovered_amp, max_recovered_phase, min_recovered_phase, mean_recovered_phase):
    print("Frequency (Hz) | Original Amplitude | Filtered Amplitude | Recovered Amplitude | Original Phase | Filtered Phase | Recovered Phase | Original Max Amp | Filtered Max Amp | Recovered Max Amp | Original Min Amp | Filtered Min Amp | Recovered Min Amp | Original Mean Amp | Filtered Mean Amp | Recovered Mean Amp | Original Max Phase | Filtered Max Phase | Recovered Max Phase | Original Min Phase | Filtered Min Phase | Recovered Min Phase | Original Mean Phase | Filtered Mean Phase | Recovered Mean Phase")
    print("-" * 217)
    for i in range(len(original_freqs)):
        print(f"{original_freqs[i]:>15.2f}  | {max_orig_amp[i]:>15.2f} | {max_filtered_amp[i]:>15.2f} | {max_recovered_amp[i]:>15.2f} | {min_orig_amp[i]:>15.2f} | {min_filtered_amp[i]:>15.2f} | {min_recovered_amp[i]:>15.2f} | {mean_orig_amp[i]:>15.2f} | {mean_filtered_amp[i]:>15.2f} | {mean_recovered_amp[i]:>15.2f} | {max_orig_phase[i]:>20.2f} | {max_filtered_phase[i]:>20.2f} | {max_recovered_phase[i]:>20.2f} | {min_orig_phase[i]:>20.2f} | {min_filtered_phase[i]:>20.2f} | {min_recovered_phase[i]:>20.2f} | {mean_orig_phase[i]:>20.2f} | {mean_filtered_phase[i]:>20.2f} | {mean_recovered_phase[i]:>20.2f}")

"""