from wav_processing import file_to_lst, filter_wav, reverse_filter_wav
from analysis_viz import analyze_signal,plot_amplitude_spectrum, Plot_des_signaux_temporels#, plot_phase_spectrum, analyze_frequencies,print_frequency_comparison
import os
from fft import compute_rfft
from time_domain_s_processing import generate_time_vector_t_fs_n, generate_t_and_n_for_lists_of_T,generate_sinusiodal_signal
from frequency_domain_s_processing import generate_frequency_vector_f_fs


def main():
    # Define input file path
    input_file = "Exo_25.wav"

    # Define frequency ranges for filtering
    low_freq_range = (20, 200)  # Example: Low-frequency range from 20 Hz to 200 Hz
    high_freq_range = (1000, 5000)  # Example: High-frequency range from 1000 Hz to 5000 Hz

    # Import file
    print("1. Import file")

    S, Fs = file_to_lst(input_file)

    # 1. Verify Sampling Rate
    print("Actual Sampling Rate:", Fs)
    
    # 2. Verify Frequency Bins
    N = len(S)
    T = T = N / Fs
    generate_t_and_n_for_lists_of_T(Fs,T,start_time=0)
    # 3. Perform FFT on audio data
    print("2. Calculate RFFT")
    rfft_result, A, phi = compute_rfft(S)

    # 3. Analyze the original audio
    print("3. Analyzing original audio:")
    fr_orig, _, _, Fs_orig, _, _, _, T, t = analyze_signal(rfft_result, Fs)
    
    #4. Plot Original signal
    print("4. Plots")
    plot_amplitude_spectrum(A)
    Plot_des_signaux_temporels(t, T,rfft_result)
    
    #Apply frequency domain filtering
    print("\n 5. Filter based on frequency ranges")
    output_file_filtered_freq = "filtered_audio_freq.wav"
    filter_wav(input_file, low_freq_range, high_freq_range, output_file_filtered_freq)
    print("\n5.1 Analysis of Filtered Audio (Frequency):")
    S1, Fs1 = file_to_lst(output_file_filtered_freq)
    N1 = len(S)
    T1 =  N1 / Fs1
    t1,n1 = generate_t_and_n_for_lists_of_T(Fs1,T1,start_time=0)
    fr_recovered_freq, _, rfft_result, Fs_recovered_freq, A1, _,  _, T, t = analyze_signal(S1, Fs1)

    # 5. Plot Filtered signal
    print("5.2 Plots Filtered signal")
    plot_amplitude_spectrum(A1)
    Plot_des_signaux_temporels(t1, T,S1)
   
    #Reverse filtering to recover the original signal
    print("\n6. Reverse frequency domain filtering")
    output_file_recovered_freq = "recovered_audio_freq.wav"
    reverse_filter_wav(output_file_filtered_freq, low_freq_range, high_freq_range, output_file_recovered_freq)


    # Analyze the recovered audio
    print("\n6.1 Analysis of Recovered Audio (Frequency):")
    S2, Fs2 = file_to_lst(output_file_recovered_freq)
    N2 = len(S)
    T2 =  N2 / Fs2
    t2,n2 = generate_t_and_n_for_lists_of_T(Fs1,T1,start_time=0)
    fr_recovered_freq, _, rfft_result, Fs_recovered_freq, A, _,  _, T, t = analyze_signal(S2, Fs2)

    print("5.2 Plots Filtered signal")
    plot_amplitude_spectrum(A)
    Plot_des_signaux_temporels(t2, T2,S2)
   

    #Clean up intermediate files
    os.remove(output_file_filtered_freq)
    os.remove(output_file_recovered_freq)

"""
    Step 2: Apply frequency domain filtering
    print("\nFiltering based on frequency ranges...")
    output_file_filtered_freq = "filtered_audio_freq.wav"
    filter_wav(input_file, low_freq_range, high_freq_range, output_file_filtered_freq)
    S1, Fs1 = file_to_lst(output_file_filtered_freq)
    fr_filtered_freq, _, _, Fs_filtered_freq, _, _, _, _, _ = analyze_signal(S1, Fs1)

    # Display analysis results for each version of the audio file
    print("\nOriginal Audio Analysis:")
    print("Sampling Rate (Fs):", Fs_orig, "Hz")
    print("Frequency Range:", min(fr_orig), "-", max(fr_orig), "Hz")

    print("\nFiltered Audio (Frequency) Analysis:")
    print("Sampling Rate (Fs):", Fs_filtered_freq, "Hz")
    print("Frequency Range:", min(fr_filtered_freq), "-", max(fr_filtered_freq), "Hz")

    Reverse filtering to recover the original signal
    print("\nReversing frequency domain filtering...")
    output_file_recovered_freq = "recovered_audio_freq.wav"
    reverse_filter_wav(output_file_filtered_freq, low_freq_range, high_freq_range, output_file_recovered_freq)

    # Analyze the recovered audio
    print("\nAnalysis of Recovered Audio (Frequency):")
    S3, Fs3 = file_to_lst(output_file_recovered_freq)
    fr_recovered_freq, _, _, Fs_recovered_freq, _, _,  _, _, _ = analyze_signal(S3, Fs3)

    print("\nRecovered Audio (Frequency) Analysis:")
    print("Sampling Rate (Fs):", Fs_recovered_freq, "Hz")
    print("Frequency Range:", min(fr_recovered_freq), "-", max(fr_recovered_freq), "Hz")

    # Plot amplitude and phase spectra for original, filtered, and recovered signals
    plot_amplitude_spectrum(S, Fs, "Original Signal Amplitude Spectrum")
    plot_amplitude_spectrum(S1, Fs1, "Filtered Signal Amplitude Spectrum")
    plot_amplitude_spectrum(S3, Fs3, "Recovered Signal Amplitude Spectrum")

    plot_phase_spectrum(S, Fs, "Original Signal Phase Spectrum")
    plot_phase_spectrum(S1, Fs1, "Filtered Signal Phase Spectrum")
    plot_phase_spectrum(S3, Fs3, "Recovered Signal Phase Spectrum")

    # Full frequency comparison
    xf_orig, max_amplitude_orig, min_amplitude_orig, mean_amplitude_orig, max_phase_orig, min_phase_orig, mean_phase_orig = analyze_frequencies(S, Fs)
    xf_filtered, max_amplitude_filtered, min_amplitude_filtered, mean_amplitude_filtered, max_phase_filtered, min_phase_filtered, mean_phase_filtered = analyze_frequencies(S1, Fs)
    xf_recovered, max_amplitude_recovered, min_amplitude_recovered, mean_amplitude_recovered, max_phase_recovered, min_phase_recovered, mean_phase_recovered = analyze_frequencies(S3, Fs)

    print_frequency_comparison(
        xf_orig, max_amplitude_orig, min_amplitude_orig, mean_amplitude_orig, max_phase_orig, min_phase_orig, mean_phase_orig,
        xf_filtered, max_amplitude_filtered, min_amplitude_filtered, mean_amplitude_filtered, max_phase_filtered, min_phase_filtered, mean_phase_filtered,
        xf_recovered, max_amplitude_recovered, min_amplitude_recovered, mean_amplitude_recovered, max_phase_recovered, min_phase_recovered, mean_phase_recovered
    )



    
"""
if __name__ == "__main__":
    main()
