#THEORY
""""
Class for handling frequency components of signals.

        Parameters:
        - t: Time vector (list or array).
        - T: Duration of the signal (float or int).
        - n: Number of samples (int) : N = T * fs 
        - N: lenght of the signal: N = len(S)
        - Fs: Sampling frequency of Signal(float or int)
        - fs = Sampling frquency of interval: the period lenght of the interval fs = 1/fs
        - delta_t: Time interval (float or int). It's the time difference between each sample in a discrete-time signal. 
            In continuous-time signals, it would be infinitesimally small, but in discrete-time signals, 
            it's the actual time spacing between samples. A smaller delta_t implies a higher sampling rate, 
            capturing more details of the signal in the time domain.
        - period: duration of one complete cycle of the waveform
        - A:Amplitude is the maximum displacement of the waveform from its mean value: M = sqrt(a^2 + b^2) 
        - freqs: This refers to an array or list of frequency values. Each value represents a 
            specific frequency component present in the signal.
        - f0: fundamental frequency is the lowest frequency component present in a periodic waveform. 
            It represents the frequency at which the waveform completes one full cycle of oscillation.
        - n: (Harmonics)integer multiples of the fundamental frequency present in a waveform. 
            harmonics are represented by integer multiples of the fundamental frequency f0, the number factoring fr
        - Phi : Phase is the temporal alignment or timing offset of a waveform relative to a 
            reference point or another waveform. It indicates where a waveform begins within its cycle, measured in terms of time: phi = arctan(b / a)
        - delta_f: represents the frequency resolution in the frequency domain. 
            It's the difference between adjacent frequency bins in a frequency spectrum obtained through Fourier Transform
        - Mt: (modulated time): This operation effectively wraps the time values within one period: (t % fs) fs as 1/fs

FFT functions
1. `np.fft.fft()`:(from fr to A and phi) Computes the one-dimensional Discrete Fourier Transform (DFT) of a sequence, yielding complex-valued DFT coefficients representing both magnitude and phase for each frequency component.
2. `np.fft.rfft(S)`:(from A and Phi to fr) Calculates the one-dimensional DFT of a real-valued sequence, producing a complex-valued result containing only the non-redundant positive-frequency components due to the symmetry of real inputs.
3. `np.fft.ifft()`: (from frequency to time domain)Computes the inverse Discrete Fourier Transform (IDFT), converting frequency-domain representation back to the time-domain for complex-valued sequences.
4. `np.fft.irfft(S,factor)`: from time to frequency domain)Computes the inverse DFT for real-valued sequences, specifically tailored to efficiently reconstruct the time-domain representation from the frequency-domain result obtained with `np.fft.rfft()`.
5. np.fft.rfftfreq(N) :computes the frequencies corresponding to the Fourier coefficients obtained from the real-input data. Specifically:
        """
