import numpy as np
from struct import pack, iter_unpack
import wave as w
from fft import compute_rfft, compute_irfft, compute_irfft_fixed_length
from time_domain_s_processing import generate_time_vector_t_fs_n
from frequency_domain_s_processing import generate_frequency_vector_f_fs
import random

# FILE PROCESSING

def lst_to_file( lst , name , nchannels = 1 , sampwidth = 2 , sample_rate = 44100 , norm = 1):
######## Transforme une liste en un fichier wave avec par defaut un encodage sur 16 bits et un sampling a 44100Hz
######## Il normalise automatiquement au maximum du son si norm = 1.
######## Attention, les valeurs dans la liste doivent etre des entiers entre -32678 et 32677 si pas normalise'.
######## Cette fonction ne retourne rien.
######## lst est la liste des valeurs, name un string contenant le nom du fichier (avec .wav).

    print("saving ", name)
    M = abs(max( lst , key = abs ) )
    data = bytearray()
    if norm and (M != 0):
        for k in lst:
            data.extend(pack('h',int( round(k/M*32677) )) )
    else:
        for k in lst:
            data.extend(pack('h',int( k )) )
    f = w.open( name ,'wb')
    f.setnchannels(nchannels)
    f.setsampwidth(sampwidth)
    f.setframerate(sample_rate)
    f.setcomptype('NONE', 'none')
    f.writeframes(data)
    f.close()

def file_to_lst( name ):

#########################################################################################
########### Deux fonctions pour lire et ecrire des fichiers .wav (mono) #################
#########################################################################################

######## Lecture:
######## Ouvre un fichier wave (une seule piste mono) et retourne une paire contenant:
######## - une liste avec toutes les valeurs du fichier
######## - le taux d'echantillonnage
######## name est un string avec le nom du fichier entier (avec .wav).
    print("reading ",name)
    wro = w.open( name , "rb" )
    sample_rate = wro.getframerate()
    length = wro.getnframes()
    uuu = wro.readframes(length)
    aaa = iter_unpack( 'h' , uuu )     
    return [k[0] for k in aaa] , sample_rate
    """
def filter_frequency_wav(file_path, low_range, high_range, output_file="altered_audio.wav"):

    Perform audio alteration by manipulating specific frequency components of the audio signal.

    Parameters:
        file_path (str): Path to the input WAV file.
        low_range (tuple): Tuple containing the lower and upper bounds of the low-frequency range.
        high_range (tuple): Tuple containing the lower and upper bounds of the high-frequency range.
        output_file (str, optional): Output WAV file path. Defaults to "altered_audio.wav".

    Returns:
        array_like: Altered audio signal.

    audio_data, Fs = file_to_lst(file_path)

    # Compute RFFT of the original audio
    rfft_result, _, _ = compute_rfft(audio_data)
    N = len(audio_data)

    # Find the frequency vector
    fr,_ = generate_frequency_vector_f_fs(N, Fs)

    # Find the indices corresponding to the specified frequency ranges
    low_indices = np.where((fr >= low_range[0]) & (fr <= low_range[1]))[0]
    high_indices = np.where((fr >= high_range[0]) & (fr <= high_range[1]))[0]

    # Apply filter to frequency-domain signal
    rfft_result_altered = rfft_result.copy()
    rfft_result_altered[low_indices] *= 0  # Zero out low-frequency components
    rfft_result_altered[high_indices] *= 0  # Zero out high-frequency components

    # Compute inverse RFFT to obtain altered audio
    audio_data_altered = compute_irfft(rfft_result_altered, 1)

    # Save the altered audio to a WAV file
    lst_to_file(audio_data_altered, output_file, sample_rate=Fs)

    return audio_data_altered

def reverse_filter_frequency_wav(file_path, low_range, high_range, output_file="recovered_audio.wav"):
    Reverse the filtering process to recover the original audio signal.

    Parameters:
        file_path (str): Path to the altered WAV file.
        low_range (tuple): Tuple containing the lower and upper bounds of the low-frequency range.
        high_range (tuple): Tuple containing the lower and upper bounds of the high-frequency range.
        output_file (str, optional): Output WAV file path. Defaults to "recovered_audio.wav".

    # Read the altered audio file
    audio_data_altered, Fs = file_to_lst(file_path)
    # Compute RFFT of the altered audio
    rfft_result_altered,_,_ = compute_rfft(audio_data_altered)
    print(type(rfft_result_altered))
    N = len(audio_data_altered)

    # Find the frequency vector
    f,fs = generate_frequency_vector_f_fs(N, Fs)

    # Find the indices corresponding to the specified frequency ranges
    low_indices = np.where((f >= low_range[0]) & (f <= low_range[1]))[0]
    high_indices = np.where((f >= high_range[0]) & (f <= high_range[1]))[0]

    # Apply reverse filter to recover original signal
    rfft_result_recovered = rfft_result_altered.copy()
    rfft_result_recovered[low_indices] *= 1  # Restore low-frequency components
    rfft_result_recovered[high_indices] *= 1  # Restore high-frequency components

    # Compute inverse RFFT to obtain recovered audio
    audio_data_recovered = compute_irfft(rfft_result_recovered, 1)

    # Save the recovered audio to a WAV file
    lst_to_file(audio_data_recovered, output_file, sample_rate=Fs)

def filter_time_wav(file_path, low_range, high_range, output_file="altered_audio.wav"):

    Perform audio alteration by manipulating specific frequency components of the audio signal.

    Parameters:
        file_path (str): Path to the input WAV file.
        low_range (tuple): Tuple containing the lower and upper bounds of the low-frequency range.
        high_range (tuple): Tuple containing the lower and upper bounds of the high-frequency range.
        output_file (str, optional): Output WAV file path. Defaults to "altered_audio.wav".

    Returns:
        array_like: Altered audio signal.


    audio_data, Fs = file_to_lst(file_path)

    # Convert the audio data into a NumPy array
    S = np.array(audio_data)

    # Compute the time vector
    t, _, _ = generate_time_vector_t_fs_n(Fs, len(S))

    # Find the indices corresponding to the specified time ranges
    low_indices = np.where((t >= low_range[0]) & (t <= low_range[1]))[0]
    high_indices = np.where((t >= high_range[0]) & (t <= high_range[1]))[0]

    # Apply filter to time-domain signal
    S_altered = S.copy()
    S_altered[low_indices] *= 0  # Zero out low-frequency components
    S_altered[high_indices] *= 0  # Zero out high-frequency components

    # Save the altered audio to a WAV file
    lst_to_file(S_altered, output_file, sample_rate=Fs)

    return S_altered

def reverse_filter_time_wav(file_path, low_range, high_range, output_file="recovered_audio.wav"):

    Reverse the filtering process to recover the original audio signal.

    Parameters:
        file_path (str): Path to the altered WAV file.
        low_range (tuple): Tuple containing the lower and upper bounds of the low-frequency range.
        high_range (tuple): Tuple containing the lower and upper bounds of the high-frequency range.
        output_file (str, optional): Output WAV file path. Defaults to "recovered_audio.wav".

    # Read the altered audio file
    S_altered, Fs = file_to_lst(file_path)

    # Compute the time vector
    t, _, _ = generate_time_vector_t_fs_n(Fs, len(S_altered))

    # Find the indices corresponding to the specified time ranges
    low_indices = np.where((t >= low_range[0]) & (t <= low_range[1]))[0]
    high_indices = np.where((t >= high_range[0]) & (t <= high_range[1]))[0]

    # Apply reverse filter to recover original signal
    S_recovered = S_altered.copy()
    S_recovered[low_indices] *= 1  # Restore low-frequency components
    S_recovered[high_indices] *= 1  # Restore high-frequency components

    # Save the recovered audio to a WAV file
    lst_to_file(S_recovered, output_file, sample_rate=Fs)
    """

def filter_wav(file_path, low_range, high_range, output_file="altered_audio.wav"):
    """
    Perform audio alteration by manipulating specific frequency components of the audio signal.

    Parameters:
        file_path (str): Path to the input WAV file.
        low_range (tuple): Tuple containing the lower and upper bounds of the low-frequency range.
        high_range (tuple): Tuple containing the lower and upper bounds of the high-frequency range.
        output_file (str, optional): Output WAV file path. Defaults to "altered_audio.wav".

    Returns:
        array_like: Altered audio signal.
    """

    audio_data, Fs = file_to_lst(file_path)


    # Convert the audio data into a NumPy array
    S = np.array(audio_data)

    # Compute RFFT of the original audio
    rfft_result, _, _ = compute_rfft(S)
    N = len(S)
    
    # Find the maximum magnitude in the RFFT
    M = max(np.abs(rfft_result[1:]))
    
    # Alter frequency components within the specified ranges
    for index in list(range(*low_range)) + list(range(*high_range)):
        A = random.random() * M * 20 #20 ensures that the altered components have a significant impact on the signal while still preserving its overall characteristics. 
        phi = 2 * np.pi * random.random() #ensures that the phase angle falls within the range of [0, 2π],
        rfft_result[index] = A * np.exp(1j * phi)
    
    # Compute inverse RFFT to obtain altered audio
    S_altered = np.fft.irfft(rfft_result, N)
    
    # Save the altered audio to a WAV file
    lst_to_file(S_altered, output_file, sample_rate=44100)
    
    return S_altered

def reverse_filter_wav(file_path, low_range, high_range, output_file="recovered_audio.wav"):
    """
    Reverse the filtering process to recover the original audio signal.

    Parameters:
        file_path (str): Path to the altered WAV file.
        low_range (tuple): Tuple containing the lower and upper bounds of the low-frequency range.
        high_range (tuple): Tuple containing the lower and upper bounds of the high-frequency range.
        output_file (str, optional): Output WAV file path. Defaults to "recovered_audio.wav".
    """
    # Read the altered audio file
    S_altered, Fs = file_to_lst(file_path)
    
    # Compute RFFT of the altered audio
    F_altered = np.fft.rfft(S_altered)
    N = len(S_altered)
    
    # Remove altered frequency components within the specified ranges
    for index in list(range(*low_range)) + list(range(*high_range)):
        F_altered[index] = 0
    
    # Compute inverse RFFT to obtain recovered audio
    S_recovered = np.fft.irfft(F_altered, N)
    
    # Save the recovered audio to a WAV file
    lst_to_file(S_recovered, output_file, sample_rate=Fs)

