package ch.hepia.numeric;

import org.junit.jupiter.api.Test;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.Assertions.assertFalse;


class VectorTest {

    @Test
    void vectorMainOperations() {
        Vector v1 = Vector.of(1.0, 2.0, 3.0);
        Vector v2 = Vector.of(-1.0, -2.0, -3.0);
        Vector v3 = Vector.of(-1.0, -2.0, -3.0);
        Vector v4 = Vector.of(-50.0, -2.0, -3.0);
        assertEquals(v1.add(v2), Vector.of(0.0, 0.0, 0.0));
        assertEquals(v1.sub(v2), Vector.of(2.0, 4.0, 6.0));
        assertEquals(v4.sub(v3), Vector.of(-49.0, 0.0, 0.0));
        assertEquals(v1.mul(3.0), Vector.of(3.0, 6.0, 9.0));
        assertEquals(v1.mul(-0.0), Vector.of(-0.0, -0.0, -0.0));
        assertEquals(v1.mul(0.0), Vector.of(0.0, 0.0, 0.0));
        assertEquals(Vector.empty().len(), 0);
        assertEquals(Vector.of(1.0, 2.0, 1.0).len(), 3);
    }

    @Test
    void vectorCreation() {
        assertEquals(Vector.zeros(3), Vector.of(0.0, 0.0, 0.0));
        assertEquals(Vector.ones(3), Vector.of(1.0, 1.0, 1.0));
        //assertEquals(Vector.of(1.0, 2.0).map( d -> d * 2.0), Vector.of(2.0, 4.0));
        assertEquals(Vector.fill(3, 1.7), Vector.of(1.7, 1.7, 1.7));
        //assertEquals(Vector.tabulate(4, i -> i*5.0), Vector.of(0.0, 5.0, 10.0, 15.0));
    }

    @Test
    void vectorLinespace() {
        assertEquals(Vector.linespace(0.0, 1.0, 3), Vector.of(0.0, 0.5, 1.0));
        assertEquals(Vector.linespace(0.0, 1.0, 5), Vector.of(0.0, 0.25, 0.5, 0.75, 1.0));
    }

    @Test
    void vectorNormAndSum() {
        assertEquals(Vector.of(1.0, 2.0, 2.0).norm(), 3.0);
        assertEquals(Vector.sum(List.of(Vector.of(1.0, 2.0, 1.0), Vector.of(0.0, 0.0, 1.0))).norm(), 3.0);
        assertEquals(
                Vector.sum(List.of(Vector.of(1.0, 2.0, 1.0), Vector.of(0.0, 0.0, 1.0))).norm(),
                Vector.norms(List.of(Vector.of(1.0, 2.0, 1.0), Vector.of(0.0, 0.0, 1.0)))
        );
        assertEquals(Vector.sum(List.of(Vector.of(1.0, 2.0, 1.0), Vector.of(0.0, 0.0, 1.0))), Vector.of(1.0, 2.0, 2.0));
        assertEquals(Vector.sum(List.of(Vector.of(1.0, 2.0, 1.0), Vector.of(0.0, 0.0, 1.0))), Vector.of(1.0, 2.0, 2.0));
    }

    @Test
    void vectorTranspose() {
        Vector v1 = Vector.of(1.0, 2.0, 3.0);
        Vector v2 = Vector.of(1.0, 0.0, -1.0);
        assertEquals(v1.t().dot(v2), -2.0);

        // * v1.dot(v2) should not compile !!!
        // * only a transposed vector with a vector

        Vector v3 = Vector.of(1.0, 2.0, 3.0);
        Vector v4 = Vector.of(1.0, 2.0, 3.0);
        assertEquals( v3.t().dot(v4), 14.0 );
        assertEquals( v3.t().sub(v4.t()), Vector.of(0.0, 0.0, 0.0).t());
    }

    @Test
    void vectorToString() {
        Vector v = Vector.of(1.0, 2.0, 3.0);
        assertEquals(v.toString(), "Vector[1.0, 2.0, 3.0]");
        assertEquals(v.t().toString(), "Transposed[1.0, 2.0, 3.0]");
    }

    @Test
    void vectorSlice() {
        Vector v = Vector.of(1.0, 2.0, 3.0, 4.0, 5.0);
        assertEquals(v.sliceFrom(2), Vector.of(3.0, 4.0, 5.0));
        assertEquals(v.sliceTo(3), Vector.of(1.0, 2.0, 3.0));
        assertEquals(v.slice(2,4), Vector.of(3.0, 4.0));
        assertEquals(v.slice(4,4), Vector.empty());
        assertEquals(v.slice(4,2), Vector.empty());
        assertEquals(v.removed(2), Vector.of(1.0, 2.0, 4.0, 5.0));
    }

    @Test
    void vectorConcat() {
        Vector v1 = Vector.of(1.0, 2.0, 3.0);
        Vector v2 = Vector.of(-1.0, -2.0, -3.0);
        assertEquals(v1.concat(v2), Vector.of(1.0, 2.0, 3.0, -1.0, -2.0, -3.0));
    }

}
