package ch.hepia.numeric;

import java.util.List;
import java.util.ArrayList;
import java.util.function.DoubleFunction;
import java.util.function.Function;

final public class Vector {

    final private List<Double> lstVector;// = new ArrayList<Double>();

    private Vector() {
      this.lstVector=new ArrayList<Double>();
    }

    private Vector(Double... elements) {
      this.lstVector=new ArrayList<Double>();
      for(double e:elements)
      {
        lstVector.add(e);
      }
    }

    private Vector(List<Double> elements) {
      this.lstVector=elements;
    }

    public Transposed t() {
        return new Transposed(this);
    }

    public int len() {
        return this.lstVector.size();
    }

    public double get(int i) {
      return this.lstVector.get(i);
    }
    void set(int i, double value) {
        this.lstVector.set(i,value);
    }

    public Vector add(Vector that) {
        Vector v = new Vector();
        for(int i=0;i<this.len();i++)
        {
          v.lstVector.add(Double.sum(this.get(i),that.get(i)));
        }
        return v;
    }

    public Vector mul(double m) {
        Vector v = new Vector();
        for(double e:this.lstVector)
        {
          v.lstVector.add(e*m);
        }
        return v;
    }

    public Vector sub(Vector that) {
      Vector v = new Vector();
      for(int i=0;i<this.len();i++)
      {
        v.lstVector.add(this.get(i)-that.get(i));
      }
      return v;
    }

    public double norm() {
        double power=0;
        for(double e:this.lstVector)
        {
          power+=(e*e);
        }
        return Math.sqrt(power);
    }

    public Vector sliceFrom(int i) {
        return slice (i,this.len());
    }

    public Vector sliceTo(int i) {
        return slice (0,i);
    }

    public Vector slice(int from, int to) {
        Vector v =new Vector();
        if (from>=to){
          return v;
        }
        else
        {
          for (double d : this.lstVector.subList(from,to))
          {
            v.lstVector.add(d);
          }
          return v;
        }
    }

    public Vector removed(int i)
    {
      Vector v = this.copy();
      v.lstVector.remove(i);
      return v;
    }

    public Vector concat(Vector that)
    {
      Vector v = Vector.zeros(this.len()+that.len());
      for(int i=0;i<v.len();i++)
      {
        if(i<this.len())
        {
          v.set(i,this.get(i));
        }
        else
        {
          v.set(i,that.get(i-this.len()));
        }
      }
      return v;
    }

    public Vector map(DoubleFunction<Double> f) {//ne pas faire
        throw new UnsupportedOperationException("This feature isn't implemented yet");
    }

    public Vector copy()
    {
      Vector v = Vector.zeros(this.len());
      for(int i=0;i<v.len();i++)
      {
        v.set(i,this.get(i));
      }
      return v;
    }

    void checkVectorLengthOrThrow(Vector that){
        throw new UnsupportedOperationException("This feature isn't implemented yet");
    }

    public static Vector of(Double... elements) {
       return new Vector(elements);
    }

    public static Vector of(List<Double> elements) {
       return new Vector(elements);
    }

    public static Vector empty() {
      return new Vector();
    }

    public static Vector fill(int nb, double value) {
        Vector v = new Vector();
        for(int i = 0; i < nb; i++)
        {
          v.lstVector.add(value);
        }
        return v;
    }

    public static Vector zeros(int nb) {
        return Vector.fill(nb,0.0);
    }

    public static Vector ones(int nb) {
      return Vector.fill(nb,1.0);
    }

    public static Vector linespace(double from, double to, int nb)
    {
      double step=(to-from)/(nb-1);
      Vector v = Vector.zeros(nb);
      for(int i=0;i<nb;i++)
      {
          v.set(i,from+(step*i));
      }
      return v;
    }

    //ne pas faire
    public static Vector tabulate(int nb, Function<Integer, Double> f)
    {
        throw new UnsupportedOperationException("This feature isn't implemented yet");
    }

    public static Vector sum(List<Vector> vs)
    {
      int length=vs.get(0).len();
      Vector v = Vector.zeros(length);
      for(int e=0;e<length;e++)
      {
        for(Vector vLst:vs)
        {
          v.set(e,Double.sum(v.get(e),vLst.get(e)));
        }
      }
      return v;
    }

    public static double norms(List<Vector> vs) {
      return sum(vs).norm();
    }


    @Override
    public String toString() {
      List<String> strings = new ArrayList<String>();
      for (Double d : this.lstVector) {
          // Apply formatting to the string if necessary
          strings.add(d.toString());
      }
      return "Vector"+String.valueOf(strings);
    }


    @Override
    public boolean equals(Object obj) {
      if(obj instanceof Vector)
      {
        for(int i=0;i<this.len();i++)
        {
          if(((Vector)obj).get(i)!=this.get(i))
          {
            return false;
          }
        }
        return true;
      }
      else
      {
        return false;
      }
    }
}
