package ch.hepia.numeric;

import java.util.List;
import java.util.ArrayList;

public class Transposed{

    final private Vector v;

    Transposed(Vector v) {
        this.v = v;
    }

    public double dot(Vector vect)
    {
        double resultat=0;
        for (int index=0;index<=vect.len()-1;index++)
        {
          resultat+=v.get(index)*vect.get(index);
        }
        return resultat;
    }

    public Transposed sub(Transposed t){
        return new Transposed(t.v.sub(v));
    }

    public Vector t(){
        return this.v;
    }

    @Override
    public String toString() {
      List<String> strings = new ArrayList<String>();
      for(int i=0;i<this.t().len();i++)
      {
        strings.add(Double.valueOf(this.t().get(i)).toString());
      }
      return "Transposed"+String.valueOf(strings);
    }

    @Override
    public boolean equals(Object obj) {
      if(obj instanceof Transposed)
      {
        for(int i=0;i<this.t().len();i++)
        {
          if(((Transposed)obj).t().get(i)!=this.t().get(i))
          {
            return false;
          }
        }
        return true;
      }
      else
      {
        return false;
      }
    }
}
